package cn.com.duiba.projectx.sdk.pay.wxfavorsuercoupon;


import java.io.Serializable;

/**
 * 权益发放结果
 *
 * @author zhangdaqing
 * @date 2024/09/05
 */
public class WxInitiateBatchTransferResponse implements Serializable {

    private static final long serialVersionUID = 2323882509274354628L;

    /**
     *
     */
    private Integer orderStatus;

    /**
     * 批次创建时间
     * 说明：批次受理成功时返回，按照使用rfc3339所定义的格式，格式为YYYY-MM-DDThh:mm:ss+TIMEZONE
     * 必填，string(32)
     */
    private String createTime;

    /**
     * 批次更新时间
     * 说明：批次最近一次状态变更的时间，按照使用rfc3339所定义的格式，格式为YYYY-MM-DDThh:mm:ss+TIMEZONE
     * 选填，string(32)
     */
    private String updateTime;

    /**
     * 批次关闭原因
     * 说明：如果批次单状态为“CLOSED”（已关闭），则有关闭原因
     * 选填，string
     */
    private String closeReason;

    /**
     * 转账成功金额
     * 说明：转账成功的金额，单位为“分”。当批次状态为“PROCESSING”（转账中）时，转账成功金额随时可能变化
     * 选填
     */
    private Long successAmount;

    /**
     * 转账成功笔数
     * 说明：转账成功的笔数。当批次状态为“PROCESSING”（转账中）时，转账成功笔数随时可能变化
     * 选填
     */
    private Integer successNum;

    /**
     * 转账失败金额 说明：转账失败的金额，单位为“分”
     * 选填
     */
    private Long failAmount;

    /**
     * 转账失败笔数
     * 说明：转账失败的笔数
     * 选填
     */
    private Integer failNum;


    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public String getCloseReason() {
        return closeReason;
    }

    public void setCloseReason(String closeReason) {
        this.closeReason = closeReason;
    }

    public Long getSuccessAmount() {
        return successAmount;
    }

    public void setSuccessAmount(Long successAmount) {
        this.successAmount = successAmount;
    }

    public Integer getSuccessNum() {
        return successNum;
    }

    public void setSuccessNum(Integer successNum) {
        this.successNum = successNum;
    }

    public Long getFailAmount() {
        return failAmount;
    }

    public void setFailAmount(Long failAmount) {
        this.failAmount = failAmount;
    }

    public Integer getFailNum() {
        return failNum;
    }

    public void setFailNum(Integer failNum) {
        this.failNum = failNum;
    }

    public Integer getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(Integer orderStatus) {
        this.orderStatus = orderStatus;
    }
}
