package cn.com.duiba.projectx.sdk.timerapis;

import cn.com.duiba.projectx.sdk.BizRuntimeException;
import cn.com.duiba.projectx.sdk.TimerApi;
import cn.com.duiba.projectx.sdk.playway.base.Ranking;

import java.util.List;

public interface RankingTimerApi {

    /**
     * 获取前几名的排行榜信息
     * @param type 排行榜id
     * @param topN 前几名
     *             不允许调用超过1000名的排名，会有性能问题
     * @return ranking 列表
     * 针对排行榜内有人数要求才发奖的情况，进行前置查询
     */
    List<Ranking> getTopN(String type, int topN);

    /**
     * 对排行榜TopN进行发奖c
     * @param topN
     * @param callback
     */
    public void sendPrize(String type,int topN,RankingTimerCallback callback);

    /**
     * 更新排行榜分数,只支持从高到低排序
     * 排行榜中增加increase的分数
     * @param userId userId
     * @param type 排行榜type
     * @param increase 增加的分数
     */
    void updateSomebodyRankingScoreByIncr(String userId, String type, int increase);

    /**
     * 排行榜开奖出错，onfinish时调用，没有设置rankingConfig则不需要调用
     * 发奖异常 记录信息
     * @param type 排行榜type
     */
    void sendPrizeError(String type,String errorMessage);


    /**
     * 排行榜开奖成功，onfinish时调用，没有设置rankingConfig则不需要调用
     * 更新发奖状态
     * @param type 排行榜type
     */
    void sendPrizeSuccess(String type);

    /**
     * 获取新排行榜当前正在进行中的rankingType
     * 如果排行榜已结束，返回的是最后一期
     * 如果排行榜未开始，返回的是第一期
     *
     * @return
     * @throws BizRuntimeException
     */
    String getCurrentRankingType() throws BizRuntimeException;

    /**
     * 获取新排行榜当前正在进行中的rankingType
     * 如果排行榜已结束，返回的是最后一期
     * 如果排行榜未开始，返回的是第一期
     *
     * @param playwayId 排行榜玩法ID
     *
     * @return
     * @throws BizRuntimeException
     */
    String getCurrentRankingType(String playwayId) throws BizRuntimeException;

    /**
     * 获取新排行榜上一期的rankingType
     *
     * @return
     * @throws BizRuntimeException
     */
    String getPrefixRankingType() throws BizRuntimeException;

    /**
     * 获取新排行榜上一期的rankingType
     *
     * @param playwayId 排行榜玩法ID
     * @return
     * @throws BizRuntimeException
     */
    String getPrefixRankingType(String playwayId) throws BizRuntimeException;

    public abstract class RankingTimerCallback{
        protected TimerApi api;
        public RankingTimerCallback(TimerApi api){
            this.api=api;
        }
        /**
         * 逐个处理
         * @param index
         * @param userId
         * @return prizeId 会进行回填
         */
        public abstract String doSendPrize(int index,String userId);

        /**
         * 处理结束后回调通知，本次取TopN的数据进行处理，成功出列了successCount条数据
         * @param topN
         * @param successCount
         */
        public void onFinish(int topN,int successCount){

        }
    }

    /**
     * 获取topN的排行榜数据，自定义处理
     * @param type 排行榜type
     * @param topN topN
     * @param rankingCallable rankingCallable
     */
    void doProcess(String type, int topN, RankingCallable rankingCallable);
}
