package cn.com.duiba.projectx.sdk.utils;

import cn.com.duiba.projectx.sdk.Api;
import com.alibaba.fastjson.TypeReference;

import java.util.List;
import java.util.Map;

public interface UserDataNewApi extends Api {
    /**
     * 获取用户数据（文本类型数据）
     * @param userId
     * @param key
     * @return
     */
    String getUserData(String userId, String key);

    /**
     * 获取用户数据（Long类型数据）
     * @param userId
     * @param key
     * @return
     */
    Long getUserDataLong(String userId, String key);

    /**
     * 获取用户数据（对象类型数据）
     * @param userId
     * @param key
     * @param typeReference
     * @param <T>
     * @return
     */
    <T> T getUserDataObject(String userId, String key, TypeReference<T> typeReference);

    /**
     * 获取用户数据（对象类型数据，阅后即焚）
     * @param userId
     * @param key
     * @param typeReference
     * @param <T>
     * @return
     */
    <T> T getAndDeleteUserDataObject(String userId, String key, TypeReference<T> typeReference);

    /**
     * 批量获取用户数据，并组装map（key为用户id，value为对应文本类型数据）
     * @param userIdList 单次最多1000个，超过会抛BizRuntimeException
     * @param key
     * @return
     */
    Map<String, String> multiGetUserData(List<String> userIdList, String key);

    /**
     * 批量获取用户数据，并组装map（key为用户id，value为对应Long类型数据）
     * @param userIdList 单次最多1000个，超过会抛BizRuntimeException
     * @param key
     * @return
     */
    Map<String, Long> multiGetUserDataLong(List<String> userIdList, String key);

    /**
     * 批量获取用户数据，并组装map（key为用户id，value为对应对象类型数据）
     * @param userIdList 单次最多1000个，超过会抛BizRuntimeException
     * @param key
     * @param typeReference
     * @param <T>
     * @return
     */
    <T> Map<String, T> multiGetUserDataObject(List<String> userIdList, String key, TypeReference<T> typeReference);

    /**
     * 设置用户数据（文本类型数据）
     * @param userId
     * @param key
     * @param value
     */
    void putUserData(String userId, String key, String value);

    /**
     * 设置用户数据（文本类型数据，有过期时间）
     * @param userId
     * @param key
     * @param value
     * @param expireTime
     */
    void putUserData(String userId, String key, String value, ExpireTime expireTime);

    /**
     * 设置用户数据（Long类型数据）
     * @param userId
     * @param key
     * @param value
     */
    void putUserDataLong(String userId, String key, long value);

    /**
     * 设置用户数据（Long类型数据，有过期时间）
     * @param userId
     * @param key
     * @param value
     * @param expireTime
     */
    void putUserDataLong(String userId, String key, long value, ExpireTime expireTime);

    /**
     * 设置用户数据（对象类型数据）
     * @param userId
     * @param key
     * @param object
     * @param <T>
     */
    <T> void putUserDataObject(String userId, String key, T object);

    /**
     * 设置用户数据（对象类型数据，有过期时间）
     * @param userId
     * @param key
     * @param object
     * @param expireTime
     * @param <T>
     */
    <T> void putUserDataObject(String userId, String key, T object, ExpireTime expireTime);

    /**
     * 获取长文本数据
     * @param key
     * @return
     */
    String getBigData(String key);

    /**
     * 批量获取长文本数据，并组装map（key为对应的key，value为对应的长文本数据）
      * @param keyList 单次最多1000个，超过会抛BizRuntimeException
     * @return
     */
    Map<String, String> multiGetBigData(List<String> keyList);

    /**
     * 设置长文本数据
     * @param key
     * @param value
     */
    void putBigData(String key, String value);

    /**
     * 设置长文本数据（有过期时间）
     * @param key
     * @param value
     * @param expireTime
     */
    void putBigData(String key, String value, ExpireTime expireTime);
}
