package cn.com.duiba.projectx.sdk.utils;

/**
 * 用户锁
 *
 * 常用于防止用户并发写行为<br/>
 * 锁范围：同一个用户在一个Project内的锁 <br/>
 *
 * 使用注解 @UserConcurrentLock
 *
 */
public interface UserLock {

    /**
     * 尝试获取用户锁 <br/>
     * 务必在 finally 区块进行 释放锁 <br/>
     * 不允许在同一个线程中 在unlock 之前 在此 tryLock (非可重入锁)
     *
     * @param expireSeconds
     * @return
     */
    public boolean tryLock(int expireSeconds);
    public boolean tryLock(int expireSeconds, int maxRetryTimes, long retryIntervalTimeMillis);

    /**
     * 解锁
     */
    public void unlock();
}
