package cn.com.duiba.projectx.sdk.utils;

import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.UserRequestContext;
import com.alibaba.fastjson.JSONObject;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

/**
 * @author liujiahui
 * @since 2022/3/30
 */
public class ActivityUtils {


    /**
     * 简单手机号校验
     */
    public static final String PHONE_REG = "^1\\d{10}$" ;

    /**
     * 是否手机号码
     *
     * @param phoneNum
     * @return
     */
    public static boolean isPhoneNum(String phoneNum) {
        return Pattern.matches(PHONE_REG, phoneNum);
    }


    /**
     * 生成免登url
     *
     * @param context
     * @param api
     * @param uid
     * @return
     */
    public static String generateAutoLoginUrl(UserRequestContext context, UserRequestApi api, String uid) {

        return generateAutoLoginUrl(context, api, uid, "0","",new HashMap<>());
    }


    /**
     * 免登链接
     *
     * @param context
     * @param api
     * @param uid          partnerUserId 合作者id
     * @param appendParams 免登链接附加参数
     * @return
     */
    public static String generateAutoLoginUrl(UserRequestContext context, UserRequestApi api, String uid,String credits,String dcustom, Map<String, String> appendParams) {
        String projectId = (String) context.getValue("projectId");
        String host = context.getHttpRequest().getServerName();
        String scheme = context.getHttpRequest().getScheme();
        String redirectUrl = context.getHttpRequest().getParameter("dbredirect");
        if (org.apache.commons.lang3.StringUtils.isBlank(redirectUrl)) {
            redirectUrl = String.format("%s://%s/projectx/%s/index.html", scheme, host, projectId);
        }
        Map<String, String> params = new TreeMap<>();
        params.put("uid", uid);
        params.put("credits", credits);
        params.put("dcustom", dcustom);
        params.put("redirect", assembleUrl(redirectUrl, appendParams));
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));

        Map<String, String> signMap = api.getDuibaApi().getSignApi().doSign(Long.valueOf(api.getIntVariable("app_id")), params);
        String url = String.format("%s://%s/autoLogin/autologin", scheme, host);
        return assembleUrl(url, signMap);
    }


    private static String assembleUrl(String urlPar, Map<String, String> params) {
        StringBuilder str = new StringBuilder(urlPar);
        if (str.toString().contains("?")) {
            str.append("&");
        } else {
            str.append("?");
        }

        try {
            String timestamp = params.get("timestamp");
            if (timestamp == null || timestamp.length() == 0) {
                str.append("timestamp").append("=").append(timestamp).append("&");
            } else {
                str.append("timestamp").append("=").append(URLEncoder.encode(timestamp, "utf-8")).append("&");
            }
            params.remove("timestamp");
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }

        for (Map.Entry<String, String> entry : params.entrySet()) {
            try {
                if (entry.getValue() == null || entry.getValue().length() == 0) {
                    str.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
                } else {
                    str.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), "utf-8")).append("&");
                }
            } catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return str.toString();
    }


    /**
     * 手机号隐藏
     *
     * @param phone
     * @return
     */
    public static String dealPhoneNum(String phone) {
        if (isPhoneNum(phone)) {
            return phone.substring(0, 3) + "****" + phone.substring(8);
        }
        return phone;
    }


    /**
     * 返回谢谢参与
     *
     * @return
     */
    public static JSONObject getThanksStrategy() {
        JSONObject obj = new JSONObject();
        obj.put("prizeId", "thanks");
        obj.put("optionId", "thanks");
        obj.put("prizeType", 0);
        obj.put("name", "谢谢参与");
        return obj;
    }


}
