package cn.com.duiba.projectx.sdk.component.countdown.vo;

import cn.com.duiba.projectx.sdk.component.countdown.dto.IncomeOptionsDto;

import java.util.Date;
import java.util.List;

/**
 * @program: projectx
 * @description: 收益发放响应体
 * @author: Simba
 * @create: 2021-03-08 09:54
 **/
public class IncomeGiveResult {

    /**
     * 时间跨度类型
     */
    private int timeSpanType;
    /**
     * 是否有收益
     */
    private boolean hasIncome = false;
    /**
     * 收益发放时间
     */
    private Date incomeGiveTime;
    /**
     * 启动时间
     */
    private Date startTime;
    /**
     * 下一阶梯的秒数
     */
    private Integer nextGearSeconds;
    /**
     * 当前进度开始时间
     */
    private Date curProcessStartTime;
    /**
     * 当前进度结束时间
     */
    private Date curProcessEndTime;
    /**
     * 当前进度剩余秒数
     */
    private Long curRemainingSeconds;
    /**
     * 收益发放类型
     */
    private int incomeGiveType;
    /**
     * 每秒收益数
     */
    private Integer incomePerSeconds;
    /**
     * 未领取收益
     */
    private Integer unReceivedIncome;
    /**
     * 发奖规则id
     */
    private String ruId;
    /**
     * 收益奖项信息
     */
    private List<IncomeOptionsDto> incomePrizes;

    private Long timestamp;

    private String extra;

    public int getTimeSpanType() {
        return timeSpanType;
    }

    public boolean getHasIncome() {
        return hasIncome;
    }

    public void setHasIncome(boolean hasIncome) {
        this.hasIncome = hasIncome;
    }

    public Date getIncomeGiveTime() {
        return incomeGiveTime;
    }

    public void setIncomeGiveTime(Date incomeGiveTime) {
        this.incomeGiveTime = incomeGiveTime;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setTimeSpanType(int timeSpanType) {
        this.timeSpanType = timeSpanType;
    }

    public Integer getNextGearSeconds() {
        return nextGearSeconds;
    }

    public void setNextGearSeconds(Integer nextGearSeconds) {
        this.nextGearSeconds = nextGearSeconds;
    }

    public Date getCurProcessStartTime() {
        return curProcessStartTime;
    }

    public void setCurProcessStartTime(Date curProcessStartTime) {
        this.curProcessStartTime = curProcessStartTime;
    }

    public Date getCurProcessEndTime() {
        return curProcessEndTime;
    }

    public void setCurProcessEndTime(Date curProcessEndTime) {
        this.curProcessEndTime = curProcessEndTime;
    }

    public Long getCurRemainingSeconds() {
        return curRemainingSeconds;
    }

    public void setCurRemainingSeconds(Long curRemainingSeconds) {
        this.curRemainingSeconds = curRemainingSeconds;
    }

    public int getIncomeGiveType() {
        return incomeGiveType;
    }

    public void setIncomeGiveType(int incomeGiveType) {
        this.incomeGiveType = incomeGiveType;
    }

    public Integer getIncomePerSeconds() {
        return incomePerSeconds;
    }

    public void setIncomePerSeconds(Integer incomePerSeconds) {
        this.incomePerSeconds = incomePerSeconds;
    }

    public Integer getUnReceivedIncome() {
        return unReceivedIncome;
    }

    public void setUnReceivedIncome(Integer unReceivedIncome) {
        this.unReceivedIncome = unReceivedIncome;
    }

    public String getRuId() {
        return ruId;
    }

    public void setRuId(String ruId) {
        this.ruId = ruId;
    }

    public List<IncomeOptionsDto> getIncomePrizes() {
        return incomePrizes;
    }

    public void setIncomePrizes(List<IncomeOptionsDto> incomePrizes) {
        this.incomePrizes = incomePrizes;
    }

    public Long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public String getExtra() {
        return extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }
}

