package cn.com.duiba.projectx.sdk.component.tmraward.enums;

/**
 * @program: projectx
 * @description: 领取状态枚举
 * @author: Simba
 * @create: 2021-04-29 09:38
 **/
public enum ReceiveStatusEnum {

    START(1, "启动"),

    RECEIVED(2, "已领取"),
    ;

    private int type;

    private String desc;

    ReceiveStatusEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static ReceiveStatusEnum toEnum(int type) {
        for (ReceiveStatusEnum p : values()) {
            if (p.type == type) {
                return p;
            }
        }
        return null;
    }

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}

