package cn.com.duiba.projectx.sdk.component.participate;

import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.component.participate.dto.ParticipateQueryResult;
import cn.com.duiba.projectx.sdk.component.participate.dto.ParticipateResult;

/**
 * 参与组件Api
 */
public interface ParticipateApi extends UserRequestApi {

    /**
     * 查询
     *
     * @param playwayId 玩法ID
     * @return
     */
    ParticipateQueryResult query(String playwayId, String userId);

    /**
     * 参与
     *
     * @param playwayId 玩法ID
     * @return
     */
    ParticipateResult join(String playwayId);

    /**
     * 增加次数
     *
     * @param playwayId 玩法ID
     * @param userId 用户ID
     * @param count 次数
     * @return
     */
    boolean addCount(String playwayId, String userId, int count);
}
