package cn.com.duiba.projectx.sdk.pay.xib;

import cn.com.duiba.projectx.sdk.pay.BasePayReq;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

public class XibChargeRequest extends BasePayReq {
    private static final long serialVersionUID = 6163386043574295180L;

    /**
     * 业务ID，业务方根据需要自定义
     */
    @NotBlank(message = "业务ID不能为空")
    private String bizId;

    /**
     * 支付金额，单位为分
     */
    @NotNull(message = "缺少支付金额")
    @Min(value = 1, message = "最少支付一分钱")
    private Integer amount;

    /**
     * 订单描述
     */
    @NotBlank(message = "订单描述不能为空")
    private String orderDesc;

    /**
     * 回调地址
     */
    @NotBlank(message = "回调地址不能为空")
    private String notifyUrl;

    /**
     * 跳转地址
     */
    @NotBlank(message = "跳转地址不能为空")
    private String redirect;

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public Integer getAmount() {
        return amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public String getOrderDesc() {
        return orderDesc;
    }

    public void setOrderDesc(String orderDesc) {
        this.orderDesc = orderDesc;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getRedirect() {
        return redirect;
    }

    public void setRedirect(String redirect) {
        this.redirect = redirect;
    }
}
