package cn.com.duiba.projectx.sdk.utils;

import cn.com.duiba.projectx.sdk.BizRuntimeException;
import cn.com.duiba.projectx.sdk.pay.WxMpPayReq;
import cn.com.duiba.projectx.sdk.pay.WxMpPayResp;
import cn.com.duiba.projectx.sdk.pay.WxPayLiteReq;
import cn.com.duiba.projectx.sdk.pay.WxPayLiteResp;
import cn.com.duiba.projectx.sdk.pay.WxPayNotifyResp;
import cn.com.duiba.projectx.sdk.pay.WxPayRedPacketSendReq;
import cn.com.duiba.projectx.sdk.pay.WxPayStatus;
import cn.com.duiba.projectx.sdk.pay.WxRefundNotifyResp;
import cn.com.duiba.projectx.sdk.pay.WxSendCouponReq;
import cn.com.duiba.projectx.sdk.pay.WxSendCouponResp;
import cn.com.duiba.projectx.sdk.pay.WxTransferPayDto;
import cn.com.duiba.projectx.sdk.pay.WxTransferPaySendReq;
import cn.com.duiba.projectx.sdk.pay.WxTransferPaySendResp;
import cn.com.duiba.projectx.sdk.pay.WxWapPayReq;
import cn.com.duiba.projectx.sdk.pay.WxWapPayResp;
import cn.com.duiba.projectx.sdk.wechat.WxCouponDetail;

/**
 * @author liugq
 * @date 2020/03/22
 */
public interface WxPayApi {

    /**
     * 发起微信h5支付
     * @param request
     * @return
     */
    WxWapPayResp createWxWapPay(WxWapPayReq request) throws BizRuntimeException;

    /**
     * 支付订单状态查询
     * @param payRecordId
     * @return
     */
     WxPayStatus queryPayStatus(Long payRecordId) throws BizRuntimeException;

    /**
     * 发起微信公众号支付
     * @param request
     * @return
     */
    WxMpPayResp createWxMpPay(WxMpPayReq request) throws BizRuntimeException;

    /**
     * 发起微信小程序支付
     * @param request
     * @return
     */
    WxPayLiteResp createWxPayLitePay(WxPayLiteReq request) throws  BizRuntimeException;

    /**
     * 支付结果通知
     * @param xmlDataStr
     *1.业务方接收到回调后用下面代码，拿到字符串作为入参数
     * InputStream inputStream = request.getInputStream()) {
     * String notifyString = IOUtils.toString(inputStream);
     *
     * 2.业务处理后需要返回给微信处理结果，否则微信会重复通知
     * 可直接返回参数里的两个常量： SUCCESS / FAIL
     */
    WxPayNotifyResp payOrderNotify(String xmlDataStr)  throws BizRuntimeException;

    /**
     * 发起退款：成功后返回退款订单号，否则抛出异常
     * @param payOrderId
     * @param callbackUrl : 退款发起后接收微信回调的url
     * @return 退款订单号
     *
     */
    String createWxRefund(Long payOrderId, String callbackUrl) throws BizRuntimeException;

    /**
     * 退款结果通知
     * @param xmlDataStr
     *1.业务方接收到回调后用下面代码，拿到字符串作为入参数
     * InputStream inputStream = request.getInputStream()) {
     * String notifyString = IOUtils.toString(inputStream);
     *
     * 2.业务处理后需要返回给微信处理结果，否则微信会重复通知
     * 可直接返回参数里的两个常量： SUCCESS / FAIL
     */
    WxRefundNotifyResp refundOrderNotify(String xmlDataStr) throws BizRuntimeException;

    /**
     * 退款结果通知(自主支付模式下如需指定apiKey时使用)
     *
     *
     * @param xmlDataStr 1.业务方接收到回调后用下面代码，拿到字符串作为入参数
     *                   InputStream inputStream = request.getInputStream()) {
     *                   String notifyString = IOUtils.toString(inputStream);
     *                   <p>
     *                   2.业务处理后需要返回给微信处理结果，否则微信会重复通知
     *                   可直接返回参数里的两个常量： SUCCESS / FAIL
     */
    WxRefundNotifyResp refundOrderNotify(String xmlDataStr, String apiKey) throws BizRuntimeException;


    /**
     * 根据银行全称，获取微信支付银行返回的银行编码
     * @param bankName
     * @param type ： 1-借记卡 2-信用卡
     * @return
     */
    String getWxPayBank(String bankName, int type);

    /**
     * 微信发放优惠券（此接口当前只支持兑吧商户号，商户id:1227739602）
     *
     * @param openId 发放openId
     * @param stockId 优惠券批次号
     * @param stockCreatorMchid 制券者商户号（发放的是自己商户的优惠券则不需要填写，若发放开发者商户号创建的优惠券，则填写开发者商户号）
     * @return
     * @throws BizRuntimeException
     */
    WxSendCouponResp sendWxCoupon(String openId, String stockId, String stockCreatorMchid) throws BizRuntimeException;

    /**
     * 微信发放优惠券(自定义金额发放时使用此接口)（此接口当前只支持兑吧商户号，商户id:1227739602）
     *
     * @param openId 发放openId
     * @param stockId 优惠券批次号
     * @param stockCreatorMchid 制券者商户号（发放的是自己商户的优惠券则不需要填写，若发放开发者商户号创建的优惠券，则填写开发者商户号）
     * @param wxCouponValue 立减金面额(单位分 微信接口目前有限制最少发放1元,最大500元)
     * @return
     * @throws BizRuntimeException
     */
    WxSendCouponResp sendWxCoupon(String openId, String stockId, String stockCreatorMchid, Integer wxCouponValue) throws BizRuntimeException;

    /**
     * 微信发放优惠券，针对定时任务或MQ接口
     *
     * @param wxSendCouponReq
     * @return
     * @throws BizRuntimeException
     */
    WxSendCouponResp sendWxCoupon(WxSendCouponReq wxSendCouponReq) throws BizRuntimeException;

    /**
     * 微信发放零钱
     * @param req
     * @return
     * @throws BizRuntimeException
     */
    WxTransferPaySendResp asynWxTransfer(WxTransferPaySendReq req) throws BizRuntimeException;

    /**
     * 微信发放零钱结果查询
     * @param bizOrderNo
     * @param bizRelationId
     * @param bizRelationType
     * @return
     * @throws BizRuntimeException
     */
    WxTransferPayDto queryWxTransfer(String bizOrderNo, String bizRelationId, Integer bizRelationType) throws BizRuntimeException;


    /**
     * 异步发放微信红包
     * @param redPacketSendReq
     * @return
     * @throws BizRuntimeException
     */
    WxTransferPaySendResp asynSendWxRedPacket(WxPayRedPacketSendReq redPacketSendReq) throws  BizRuntimeException;


    /**
     * 查询福建兑吧微信立减金的详情
     * @param recordId 发奖记录Id
     * @return 使用状态
     */
    WxCouponDetail queryWxCouponDetail(String recordId)  throws BizRuntimeException ;

    /**
     * 根据福建兑吧券ID找到发奖记录ID
     * @param couponId 券ID
     * @return 星速台发奖记录ID
     * @throws BizRuntimeException 业务异常
     */
    String findRecordIdByCouponId(String couponId) throws BizRuntimeException;

    /**
     * 根据主订单找到recordId
     * @param orderNum 主订单号
     * @return  发奖记录ID
     */
    String findRecordIdByOrderNum(String orderNum);


    /**
     * 查询福建兑吧微信立减金的详情
     * @param couponId 券ID
     * @param openId 用户openId
     * @throws BizRuntimeException 业务异常
     */
    WxCouponDetail findWxCouponDetail(String couponId,String openId);
}
