package cn.com.duiba.quanyi.center.api.dto.user;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 微信用户表
 * @author kjj mybatis generator 
 * @date 2023-05-16
 */
@Data
public class UserDto implements Serializable {

    private static final long serialVersionUID = -3768716350936733065L;
    
    /**
     * 主键
     */
    private Long id;

    /**
     * 唯一ID，同一主体下唯一
     */
    private String unionId;

    /**
     * 用户的昵称
     */
    private String nickname;

    /**
     * 用户的头像
     */
    private String avatar;

    /**
     * 用户性别，1=男性，2=女性，0=未知
     */
    private Integer sex;

    /**
     * 用户所在国家
     */
    private String country;

    /**
     * 用户所在省
     */
    private String province;

    /**
     * 用户所在市
     */
    private String city;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}