package cn.com.duiba.quanyi.center.api.enums.coupon;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2023/9/1 11:42
 */
@Getter
@AllArgsConstructor
public enum WxStockTypeEnum {
    
    DISCOUNT_CUT(1, "收银台立减", false),
    COUPON_BANK(2, "银行立减金", true),
    FIRST_BIND(3, "首绑有礼", false),
    MONTHLY_CARD_SWIPING(4, "月月刷", false),
    COUPON_MCH(5, "商家代金券", true),
    ;

    /**
     * 批次类型
     */
    private final Integer type;

    /**
     * 批次类型名称
     */
    private final String typeName;

    /**
     * 是否支持API发放
     */
    private final boolean supportApi;
    
    private static final Map<Integer, WxStockTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(WxStockTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));
    
    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static WxStockTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    /**
     * 是否支持api发放
     * @param type 枚举值
     * @return true-是，false-否
     */
    public static boolean isSupportApi(Integer type) {
        WxStockTypeEnum typeEnum = getByType(type);
        if (typeEnum == null) {
            return false;
        }
        return typeEnum.isSupportApi();
    }
}
