package cn.com.duiba.quanyi.center.api.enums.coupon;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * @author xuzhigang
 * @date 2024/3/26 10:42
 **/
@Getter
@AllArgsConstructor
public enum WxCouponBankTypeEnum {
    DEBIT(1, "借记卡"),
    CREDIT(2, "信用卡"),
    ;
    private final Integer bankType;

    private final String desc;

    public static boolean isValidType(Integer bankType) {
        return Arrays.stream(values()).anyMatch(t -> Objects.equals(t.getBankType(), bankType));
    }
}
