package cn.com.duiba.quanyi.center.api.remoteservice.pkg;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.pkg.GoodsPkgChannelDto;
import cn.com.duiba.quanyi.center.api.param.pkg.GoodsPkgChannelSearchParam;

import java.util.List;

/**
 * 商品包渠道远程服务
 */
@AdvancedFeignClient
public interface RemoteGoodsPkgChannelService {
    /**
     * 根据条件查询
     * @param param 查询条件
     * @return 商品包推广渠道集合
     */
    List<GoodsPkgChannelDto> selectByParam(GoodsPkgChannelSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 商品包推广渠道
     */
    GoodsPkgChannelDto selectById(Long id);
    /**
     * 根据主键查询
     * @param name 渠道名称
     * @return 商品包推广渠道
     */
    GoodsPkgChannelDto selectByName(String name);

    /**
     * 根据商品包id查询
     *
     * @param goodsPkgId 商品包id
     * @return 商品包推广渠道
     */
    List<GoodsPkgChannelDto> selectByGoodsPkgId(Long goodsPkgId);

    /**
     * 新增
     * @param entity 商品包推广渠道
     * @return 执行结果
     */
    Long insert(GoodsPkgChannelDto entity);

    /**
     * 更新
     * @param entity 商品包推广渠道
     * @return 执行结果
     */
    int update(GoodsPkgChannelDto entity);

    /**
     * 逻辑删除
     * @param id 主键
     * @return 执行结果
     */
    int logicDelete(Long id);
}
