package cn.com.duiba.quanyi.center.api.utils;

import org.apache.commons.lang3.StringUtils;

import java.util.regex.Pattern;

public class QuanyiFormatUtils {
    /**
     * 简单手机号校验
     */
    public static final String PHONE_REG = "^1\\d{10}$" ;

    /**
     * 是否手机号码
     *
     * @param phoneNum 手机号
     * @return true 是手机号
     */
    public static boolean isPhoneNum(String phoneNum) {
        return Pattern.matches(PHONE_REG, phoneNum);
    }


    /**
     * 手机号脱敏
     * 保留前三位后四位，中间用星号代替
     * @param mobile 手机号
     */
    public static String mobileEncrypt(String mobile){
        if (StringUtils.isBlank(mobile)){
            return "";
        }
        if(!isPhoneNum(mobile)){
            return mobile;
        }
        return mobile.replaceAll("(\\d{3})\\d{4}(\\d{4})","$1****$2");
    }

}
