package cn.com.duiba.quanyi.center.api.dto.pkg;

import cn.com.duiba.quanyi.center.api.enums.coupon.AlipayActivityTakeTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 商品包sku表
 *
 * @author kjj mybatis generator
 * @date 2023-09-14
 */
@Data
public class GoodsPkgSkuDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 商品包主键
     */
    private Long goodsPkgId;

    /**
     * 商品库skuID
     */
    private Long skuId;

    /**
     * 商品库spu主键
     */
    private Long spuId;

    /**
     * 商品库spu名称
     */
    private String spuName;

    /**
     * 商品库spu类型
     */
    private Integer spuType;

    /**
     * 商品库供应商id
     */
    private Long supplierId;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 指导价，划线价，单位分，比如1元，数据存为100
     */
    private Integer marketPrice;

    /**
     * 建议售价，平台卖价，单位分，比如1元，数据存为100
     */
    private Integer sellPrice;

    /**
     * 商品规格图片
     */
    private String goodsImg;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer logicDelete;

    /**
     * 排序字段，数值越大次序越靠后
     */
    private Integer weight;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 领取方式，商品类型为支付宝立减金时有值
     * 1-链接券；2-输入账号
     *
     * @see AlipayActivityTakeTypeEnum
     */
    private Integer takeType;

    /**
     * 类型为微信立减金、支付宝立减金时，是否固定面额
     * 0-否；1-是
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer fixedAmount;

    /**
     * 面额，类型为微信立减金、支付宝立减金时，且为固定面额时有值
     */
    private Long amount;
}