package cn.com.duiba.quanyi.center.api.enums.coupon;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 支付宝立减金领取方式
 *
 * @author zzy
 * @create 2023/10/10 20:49
 **/
@Getter
@AllArgsConstructor
public enum AlipayActivityTakeTypeEnum {
    ALIPAY_UID_AUTH(1, "支付宝UID，通过H5在支付宝APP内授权得到"),
    ALIPAY_ACCOUNT_INPUT(2, "支付宝账号，用户输入"),
    ;
    /**
     * 领奖类型
     */
    private final Integer type;

    /**
     * 批次类型名称
     */
    private final String desc;
}
