package cn.com.duiba.quanyi.center.api.remoteservice.activity;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityPrizeReceiveRecordDto;

import java.util.List;

/**
 * 活动奖品领取记录
 * @author kjj mybatis generator 
 * @date 2023-08-07
 */
@AdvancedFeignClient
public interface RemoteActivityPrizeReceiveRecordService {

    /**
     * 根据活动和用户查询
     * @param activityId 活动
     * @param userId 用户
     * @return 领取记录列表
     */
    @Deprecated
    List<ActivityPrizeReceiveRecordDto> selectByActivityUser(Long activityId, Long userId);

    /**
     * 根据活动和用户查询
     * @param activityType
     * @param activityId 活动
     * @param userId 用户
     * @see cn.com.duiba.quanyi.center.api.enums.activity.ActivityTypeEnum
     * @return 领取记录列表
     */
    List<ActivityPrizeReceiveRecordDto> selectByActivityUserWithType(Integer activityType, Long activityId, Long userId);

    /**
     * 根据奖品、用户查询
     * @param activityPrizeId 奖品ID
     * @param userId 用户ID
     * @return 领取记录
     */
    @Deprecated
    ActivityPrizeReceiveRecordDto selectByActivityPrizeUser(Long activityPrizeId, Long userId);

    /**
     * 根据奖品、用户查询
     * @param activityType
     * @param activityPrizeId 奖品ID
     * @param userId 用户ID
     * @see cn.com.duiba.quanyi.center.api.enums.activity.ActivityTypeEnum
     * @return 领取记录
     */
    ActivityPrizeReceiveRecordDto selectByActivityPrizeUserWithType(Integer activityType, Long activityPrizeId, Long userId);

    /**
     * C端-用户领取记录分页查询
     * @param userId 用户ID
     * @param lastId 上次最后一个ID，第一页为null
     * @param pageSize 需要拉去的条数
     * @return 领取记录
     */
    @Deprecated
    List<ActivityPrizeReceiveRecordDto> selectUserList(Long userId, Long lastId, Integer pageSize);

    /**
     * C端-用户领取记录分页查询
     * @param activityType
     * @param userId 用户ID
     * @param lastId 上次最后一个ID，第一页为null
     * @param pageSize 需要拉去的条数
     * @see cn.com.duiba.quanyi.center.api.enums.activity.ActivityTypeEnum
     * @return 领取记录
     */
    List<ActivityPrizeReceiveRecordDto> selectUserListWithType(Integer activityType, Long userId, Long lastId, Integer pageSize);
}