package cn.com.duiba.quanyi.center.api.remoteservice.activity;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityPrizeReceiveResultDto;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityTakePrizeParamDto;

/**
 * 活动奖品领取
 *
 * @author lizhi
 * @date 2023-08-07
 */
@AdvancedFeignClient
public interface RemoteActivityPrizeReceiveService {

    /**
     * 异步领取奖品
     *
     * @param activityPrizeId 活动奖品ID
     * @param userId          用户ID
     * @param appId           微信appId
     * @return 结果
     */
    @Deprecated
    ActivityPrizeReceiveResultDto asyncReceive(Long activityPrizeId, Long userId, String appId);

    /**
     * 异步领取奖品
     *
     * @param dto 参数
     * @return 结果
     */
    ActivityPrizeReceiveResultDto takePrize(ActivityTakePrizeParamDto dto);

    /**
     * 查询领奖结果
     *
     * @param activityPrizeId 活动奖品ID
     * @param userId          用户ID
     * @return 结果
     */
    @Deprecated
    ActivityPrizeReceiveResultDto receiveResult(Long activityPrizeId, Long userId);

    /**
     * 查询领奖结果
     *
     * @param activityPrizeId 活动奖品ID
     * @param userId          用户ID
     * @return 结果
     */
    ActivityPrizeReceiveResultDto receiveResultWithType(Integer activityType, Long activityPrizeId, Long userId);
}