package cn.com.duiba.quanyi.center.api.dto.activity;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 活动奖品领取记录
 * @author kjj mybatis generator 
 * @date 2023-08-07
 */
@Data
public class ActivityPrizeReceiveRecordDto implements Serializable {

    private static final long serialVersionUID = 1983166690426515826L;
    
    /**
     * 主键
     */
    private Long id;

    /**
     * 员工用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 手机号
     */
    private String userPhone;

    /**
     * 订单号
     */
    private String bizOrderNo;

    /**
     * 微信立减金主键, tb_wx_coupon.id
     */
    private Long wxCouponId;

    /**
     * 合同主键, tb_contract.id
     */
    private Long contractId;

    /**
     * 需求主键, tb_demand.id
     */
    private Long demandId;

    /**
     * 采购单主键, tb_purchase_order.id
     */
    private Long purchaseId;

    /**
     * 采购商品主键, tb_purchase_goods.id
     */
    private Long purchaseGoodsId;

    /**
     * 商品ID
     */
    private String spuCode;

    /**
     * 活动主键, tb_activity.id
     */
    private Long activityId;

    /**
     * 活动奖品主键, tb_activity_prize.id
     */
    private Long activityPrizeId;

    /**
     * 微信批次号
     */
    private String stockId;

    /**
     * 发券商户ID
     */
    private String mchId;

    /**
     * 创建批次的商户号
     */
    private String stockCreatorMchId;

    /**
     * 面额，单位分
     */
    private Long couponAmount;

    /**
     * 订单状态, 1-处理中，2-成功，3-失败, 4-异常
     * @see cn.com.duiba.quanyi.center.api.enums.activity.ActivityPrizeOrderStatusEnum
     */
    private Integer orderStatus;

    /**
     * 最新的失败原因
     */
    private String errorMsg;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}