package cn.com.duiba.quanyi.center.api.dto.contract;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 合同表
 * @author kjj mybatis generator 
 * @date 2023-08-07
 */
@Data
public class ContractDto implements Serializable {

    private static final long serialVersionUID = 4839906531083624544L;
    
    /**
     * 主键
     */
    private Long id;

    /**
     * 合同名称
     */
    private String contractName;

    /**
     * 合作客户主键, tb_partner.id
     */
    private Long partnerId;

    /**
     * 合同编号
     */
    private String contractCode;

    /**
     * 合同文件地址
     */
    private String contractFile;

    /**
     * 消耗类型, 1-框架，2-预算
     * @see cn.com.duiba.quanyi.center.api.enums.contract.ContractConsumeTypeEnum
     */
    private Integer consumeType;

    /**
     * 消耗上限，单位分
     */
    private Long totalAmount;

    /**
     * 合作开始时间
     */
    private Date startTime;

    /**
     * 合作结束时间
     */
    private Date endTime;

    /**
     * 合同运营，多个以英文逗号分隔
     */
    private String contractOperations;

    /**
     * 合同商务，多个以英文逗号分隔
     */
    private String contractCommerce;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}