package cn.com.duiba.quanyi.center.api.dto.contract;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 合同商品表
 * @author kjj mybatis generator 
 * @date 2023-08-07
 */
@Data
public class ContractGoodsDto implements Serializable {

    private static final long serialVersionUID = 6357525696907545012L;
    
    /**
     * 主键
     */
    private Long id;

    /**
     * 合同主键, tb_contract.id
     */
    private Long contractId;

    /**
     * 商品ID
     */
    private String spuCode;

    /**
     * 商品名称，冗余避免每次查询
     */
    private String spuName;

    /**
     * 供应商名称，冗余避免每次查询
     */
    private String supplierName;

    /**
     * 金额区间
     */
    private String amountRange;

    /**
     * 成本
     */
    private String costRate;

    /**
     * 结算
     */
    private String settlementRate;

    /**
     * 结算方式
     */
    private String settlementMethod;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}