package cn.com.duiba.quanyi.center.api.dto.purchase;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 采购商品表
 * @author kjj mybatis generator 
 * @date 2023-08-07
 */
@Data
public class PurchaseGoodsDto implements Serializable {

    private static final long serialVersionUID = 5300114912265510532L;
    
    /**
     * 主键
     */
    private Long id;

    /**
     * 合同主键, tb_contract.id
     */
    private Long contractId;

    /**
     * 需求主键, tb_demand.id
     */
    private Long demandId;

    /**
     * 采购单主键, tb_purchase_order.id
     */
    private Long purchaseId;

    /**
     * 商品ID
     */
    private String spuCode;

    /**
     * 商品类型，1-实物
     * @see cn.com.duiba.goods.common.enums.goods.SpuType
     */
    private Integer spuType;

    /**
     * 商品名称，冗余避免每次查询
     */
    private String spuName;

    /**
     * 供应商名称，冗余避免每次查询
     */
    private String supplierName;

    /**
     * 面额，单位分
     */
    private Long amount;

    /**
     * 采购数量
     */
    private Long totalNum;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}