package cn.com.duiba.quanyi.center.api.dto.activity;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 活动支付订单
 * @author kjj mybatis generator 
 * @date 2023-08-07
 */
@Data
public class ActivityOrderDto implements Serializable {

    private static final long serialVersionUID = -1842074447423286864L;
    
    /**
     * 主键
     */
    private Long id;

    /**
     * 活动主键, tb_activity.id
     */
    private Long activityId;

    /**
     * 员工用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 支付金额，单位分
     */
    private Long payAmount;

    /**
     * 订单号
     */
    private String bizOrderNo;

    /**
     * 支付状态 0-订单生成，1-收单成功, 2-收单失败, 3-支付失败, 4-支付成功 5-取消支付 6-退款中 7-退款成功 8-退款失败
     * @see cn.com.duiba.kjy.paycenter.api.enums.ChargeOrderStatusEnum
     */
    private Integer payStatus;

    /**
     * 支付过期时间
     */
    private Date expireTime;

    /**
     * 支付订单号(商户订单号)
     */
    private String outTradeNo;

    /**
     * 渠道返回的交易流水号
     */
    private String transactionNo;

    /**
     * 付款银行.
     * 类型：String(16)
     * 示例值：CMC
     * 描述：银行类型，采用字符串类型的银行标识，银行类型见银行列表
     * @see cn.com.duiba.quanyi.center.api.enums.pay.WxPayBankTypeEnum
     */
    private String bankType;

    /**
     * 支付时间
     */
    private Date paidTime;

    /**
     * 渠道支付失败码
     */
    private String failureCode;

    /**
     * 渠道支付失败描述
     */
    private String failureMsg;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}