package cn.com.duiba.quanyi.center.api.remoteservice.activity;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityJobNumDto;
import cn.com.duiba.quanyi.center.api.param.activity.ActivityJobNumPageQueryParam;
import cn.com.duiba.quanyi.center.api.param.activity.ActivityWhiteListPageQueryParam;

import java.util.List;

/**
 * 活动员工工号表
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@AdvancedFeignClient
public interface RemoteActivityJobNumService {

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 活动员工工号
     */
    ActivityJobNumDto selectById(Long id);

    /**
     * 新增
     *
     * @param activityJobNumDto 活动员工工号
     * @return 执行结果
     */
    Long insert(ActivityJobNumDto activityJobNumDto);

    /**
     * 更新
     *
     * @param activityJobNumDto 活动员工工号
     * @return 执行结果
     */
    int update(ActivityJobNumDto activityJobNumDto);

    /**
     * 根据工号查询
     *
     * @param activityId 活动id
     * @param jobNum     工号
     * @return 活动员工工号
     */
    ActivityJobNumDto selectByJobNum(Long activityId, String jobNum);

    /**
     * 根据工号查询
     *
     * @param activityId 活动id
     * @param userId     用户id
     * @return 活动员工工号
     */
    List<ActivityJobNumDto> selectByUserId(Long activityId, Long userId);

    /**
     * 根据活动id批量查询
     *
     * @param param
     * @return 活动员工工号
     */
    List<ActivityJobNumDto> findPageByActivityId(ActivityJobNumPageQueryParam param);

    /**
     * 根据活动id count
     *
     * @param activityId
     * @return count
     */
    Integer countByActivityId(Long activityId);


    /**
     * 绑定小B用户
     *
     * @param activityId 活动id
     * @param jobNum     工号
     * @param userId     绑定的用户id
     * @return
     */
    int bindUser(Long activityId, String jobNum, Long userId);

    /**
     * 解绑小B用户
     *
     * @param activityId 活动id
     * @param jobNum     工号
     * @return
     */
    int unbindUser(Long activityId, String jobNum);
}