package cn.com.duiba.quanyi.center.api.remoteservice.purchase;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.purchase.PurchaseGoodsDto;

import java.util.List;

/**
 * 采购商品表
 * @author kjj mybatis generator 
 * @date 2023-08-07
 */
@AdvancedFeignClient
public interface RemotePurchaseGoodsService {

    /**
     * 根据采购商品表id查询采购商品详情
     * @param id 采购商品表id
     * @return 采购商品详情
     */
    PurchaseGoodsDto getPurchaseGoodsInfo(Long id);

    /**
     * 根据采购单id查询采购商品详情
     * @param purchaseId 采购单id
     * @return 采购商品详情
     */
    List<PurchaseGoodsDto> getPurchaseGoodsListByPurchaseId(Long purchaseId);

    /**
     * 根据采购商品表id更新采购商品
     * @param purchaseGoodsDto 采购商品信息
     * @return 操作条数
     */
    int updatePurchaseGoodsById(PurchaseGoodsDto purchaseGoodsDto);

    /**
     * 新增采购商品信息
     * @param purchaseGoodsDto 采购商品信息
     * @return 操作条数
     */
    int insertPurchaseGoods(PurchaseGoodsDto purchaseGoodsDto);

    /**
     * 根据采购商品单id删除采购商品
     * @param id 采购商品单id
     * @return 操作条数
     */
    int deletePurchaseGoods(Long id);

}