package cn.com.duiba.quanyi.center.api.remoteservice.purchase;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.purchase.PurchaseOrderDto;

import java.util.List;

/**
 * 采购单表
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@AdvancedFeignClient
public interface RemotePurchaseOrderService {

    /**
     * 根据采购单id查询采购单据
     *
     * @param id 采购单id
     * @return 采购单据
     */
    PurchaseOrderDto getPurchaseOrderInfo(Long id);

    /**
     * 根据需求单id查询采购单据
     *
     * @param demandId 需求单id
     * @return 采购单据
     */
    List<PurchaseOrderDto> getPurchaseOrderListByDemandId(Long demandId);

    /**
     * 根据id修改采购单据
     *
     * @param purchaseOrderDto 采购单据信息
     * @return 操作条数
     */
    int updatePurchaseOrder(PurchaseOrderDto purchaseOrderDto);

    /**
     * 新增采购单据
     *
     * @param purchaseOrderDto 采购单据信息
     * @return 操作条数
     */
    int insertPurchaseOrder(PurchaseOrderDto purchaseOrderDto);

    /**
     * 根据采购单id删除采购单
     *
     * @param id 采购单id
     * @return 操作条数
     */
    int deletePurchaseOrder(Long id);
}