package cn.com.duiba.quanyi.center.api.enums.ccblife;

import cn.com.duiba.quanyi.center.api.enums.activity.BankEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.*;
import java.util.stream.Collectors;

/**管辖行
 * @author xjl
 * @date 2023/11/23 16:23
 */

@Getter
@AllArgsConstructor
public enum Jurisdictional {

    BS(1,"宝石"),
    CA(2,"淳安"),
    FY(3,"富阳"),
    GX(4,"高新"),
    JD(5,"建德"),
    XS(6,"萧山"),
    YYB(7,"营业部"),
    YH(8,"余杭"),
    LP(9,"临平"),
    ZJ(10,"之江"),
    BJ(11,"滨江"),
    ZS(12,"中山"),

    ;

    public static List<Map<Integer, String>> getEnumList() {
        List<Map<Integer, String>> list = new ArrayList<>();
        for (Jurisdictional jurisdictional : Jurisdictional.values()) {
            Map<Integer, String> map = new HashMap<>();
            map.put(jurisdictional.getKey(), jurisdictional.getJurisdictionBank());
            list.add(map);
        }
        return list;
    }

    public static final Map<Integer, String> ENUM_MAP =
            Collections.unmodifiableMap(Arrays.stream(values()).
                    collect(Collectors.toMap(Jurisdictional::getKey,
                            Jurisdictional::getJurisdictionBank, (v1, v2) -> v2)));


    /**
     * key
     */
    private final Integer key;


    /**
     * 管辖行名称
     */
    private final String jurisdictionBank;


}
