package cn.com.duiba.quanyi.center.api.remoteservice.ccbLife;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.ccbLife.CcbLifeBusinessDto;
import cn.com.duiba.quanyi.center.api.param.ccbLife.BusinessPageQueryParam;
import cn.com.duiba.quanyi.center.api.param.ccbLife.CcbLifeBusinessSearchParam;
import cn.com.duiba.quanyi.center.api.param.cornucopia.StoreManagerPageQueryParam;

import java.util.List;
import java.util.Set;

/**
 * 商户表
 * @author kjj mybatis generator 
 * @date 2023-11-23
 */
@AdvancedFeignClient
public interface RemoteCcbLifeBusinessService {
     
    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return 商户集合
     */
    List<CcbLifeBusinessDto> selectList(CcbLifeBusinessSearchParam param);

    /**
     * 根据条件查询，分页
     * @param pageParam 查询条件
     * @return 建行生活门店集合
     */
    List<CcbLifeBusinessDto> findPageByParam(BusinessPageQueryParam pageParam);


    /**
     * 根据主键集合动态查询
     * @param ids 主键
     * @return 集合
     */
    List<CcbLifeBusinessDto> findAllByIds(Set<Long> ids);


    /**
     * 根据门店号查询所有的符合条件的门店信息
     * @param shopNums 门店号集合
     * @return 集合
     */
    List<CcbLifeBusinessDto> findAllByShopNums(Set<String> shopNums);

    /**
     * 统计符合条件的个数
     * @param pageParam 请求参数
     * @return 行
     */
    Integer countByParam(BusinessPageQueryParam pageParam);


    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(CcbLifeBusinessSearchParam param);



    /**
     * 根据主键查询
     * @param id 主键
     * @return 商户
     */
    CcbLifeBusinessDto selectById(Long id);

    /**
     * 新增
     * @param dto 商户
     * @return 执行结果
     */
    int insert(CcbLifeBusinessDto dto);

    /**
     * 更新
     * @param dto 商户
     * @return 影响行数
     */
    int update(CcbLifeBusinessDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 聚宝盆-门店管理分页列表查询
     * @param param 请求参数
     * @return 返回列表信息
     */
    List<CcbLifeBusinessDto> findPageWithCornucopia(StoreManagerPageQueryParam param);
}