package cn.com.duiba.quanyi.center.api.param.ccbLife;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author xjl
 * @date 2023/11/25 21:59
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class SettlementMonthSearchParam extends PageQuery {


    private static final long serialVersionUID = -1789632068405085318L;

    /**
     * 商户号
     */
    @Nullable
    private String businessNum;

    /**
     * 门店号
     */
    @Nullable
    private String shopNum;

    /**
     * 商户名
     */
    @Nullable
    private String businessName;

    /**
     * 门店名
     */
    @Nullable
    private String shopName;

    /**
     * 结算月份:开始
     */
    @Nullable
    private long monthBegin;

    /**
     * 结算月份：结束
     */
    @Nullable
    private long monthOver;

    /**
     * 确认状态 ：待确认：0（默认）；已确认：1
     */
    @NotNull
    private int status;

    /**
     *门店表主键id集合
     */
    private List<Long> businessIds;


}
