package cn.com.duiba.quanyi.center.api.remoteservice.ccbLife;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.ccbLife.CcbLifeCouponDto;
import cn.com.duiba.quanyi.center.api.param.ccbLife.CcbLifeCouponSearchParam;
import cn.com.duiba.quanyi.center.api.param.cornucopia.CouponPageQueryParam;

import java.util.List;
import java.util.Set;

/**
 * 优惠券表
 * @author kjj mybatis generator 
 * @date 2023-11-23
 */
@AdvancedFeignClient
public interface RemoteCcbLifeCouponService {
     
    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return 优惠券集合
     */
    List<CcbLifeCouponDto> selectList(CcbLifeCouponSearchParam param);

    /**
     *根据优惠券ID去优惠券表中查询对应的优惠券信息
     * @param couponIds 优惠券ID
     * @return 优惠券信息
     */
    List<CcbLifeCouponDto> findAllByCouponIds(Set<String> couponIds);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(CcbLifeCouponSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 优惠券
     */
    CcbLifeCouponDto selectById(Long id);

    /**
     * 新增
     * @param dto 优惠券
     * @return 执行结果
     */
    int insert(CcbLifeCouponDto dto);

    /**
     * 更新
     * @param dto 优惠券
     * @return 影响行数
     */
    int update(CcbLifeCouponDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 聚宝盆-优惠券管理：分页列表查询
     * @param param 请求参数
     * @return 列表数据
     */
    List<CcbLifeCouponDto> findAllPage(CouponPageQueryParam param);

    /**
     * 聚宝盆-优惠券管理：查询对应的行数
     * @param pageParam 请求参数
     * @return 行数
     */
    Integer findAllCount(CouponPageQueryParam pageParam);



}