package cn.com.duiba.quanyi.center.api.remoteservice.ccbLife;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.ccbLife.CcbLifeSettlementDetailDto;
import cn.com.duiba.quanyi.center.api.param.ccbLife.CcbLifeSettlementDetailSearchParam;
import cn.com.duiba.quanyi.center.api.param.ccbLife.StoreSettlementSearchParam;

import java.util.List;

/**
 * 商户表
 * @author kjj mybatis generator 
 * @date 2023-11-23
 */
@AdvancedFeignClient
public interface RemoteCcbLifeSettlementDetailService {
     
    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return 商户集合
     */
    List<CcbLifeSettlementDetailDto> selectList(CcbLifeSettlementDetailSearchParam param);


    /**
     * 根据条件进行分页展示
     * @param searchParam 请求参数
     * @return 返回结果
     */
    List<CcbLifeSettlementDetailDto> findPageByParam(StoreSettlementSearchParam searchParam);



    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(CcbLifeSettlementDetailSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 商户
     */
    CcbLifeSettlementDetailDto selectById(Long id);

    /**
     * 新增
     * @param dto 商户
     * @return 执行结果
     */
    int insert(CcbLifeSettlementDetailDto dto);

    /**
     * 更新
     * @param dto 商户
     * @return 影响行数
     */
    int update(CcbLifeSettlementDetailDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}