package cn.com.duiba.quanyi.center.api.remoteservice.ccbLife;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.ccbLife.CcbLifeSettlementMonthDto;
import cn.com.duiba.quanyi.center.api.param.ccbLife.BusinessMonthPageQueryParam;
import cn.com.duiba.quanyi.center.api.param.ccbLife.CcbLifeSettlementMonthSearchParam;
import cn.com.duiba.quanyi.center.api.param.ccbLife.SettlementMonthSearchParam;
import cn.com.duiba.quanyi.center.api.param.cornucopia.SettlementMonthPageQueryParam;

import java.util.List;

/**
 * 商户表
 * @author kjj mybatis generator 
 * @date 2023-11-23
 */
@AdvancedFeignClient
public interface RemoteCcbLifeSettlementMonthService {
     
    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return 商户集合
     */
    List<CcbLifeSettlementMonthDto> selectList(CcbLifeSettlementMonthSearchParam param);

    /**
     * 根据条件查询，分页
     * @param param 查询条件
     * @return 商户集合
     */
    List<CcbLifeSettlementMonthDto> findPageByParam(BusinessMonthPageQueryParam param);


    /**
     *聚宝盆-结算明细-列表查询
     * @param param 请求参数
     * @return 列表分页数据
     */
    List<CcbLifeSettlementMonthDto> findPageBySearchParam(SettlementMonthPageQueryParam param);

    /**
     * 根据条件查询对应的总行数
     * @param id 门店id
     * @param status 状态字段
     * @return 返回符合条件的行数
     */
    Integer countByParam(long id, int status);

    /**
     * 门店管理：根据月份id对对应月份的信息进行状态确认
     * @param id 月份id字段
     * @return
     */
    Boolean confirm(long id);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(CcbLifeSettlementMonthSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 商户
     */
    CcbLifeSettlementMonthDto selectById(Long id);

    /**
     * 根据条件查询结算月份表中的信息
     * @param settlementMonthSearchParam 请求参数
     * @return 返回列表信息
     */
    List<CcbLifeSettlementMonthDto> findPageWithBusinessIds(SettlementMonthSearchParam settlementMonthSearchParam);


    /**
     * 根据条件查询对应的行数
     * @param param 请求参数
     * @return 返回结果行数
     */
    Integer findAllCountWithBusinessIds(SettlementMonthSearchParam param);

    /**
     * 根据条件查询结算月份表中的对应的行数
     * @param param 请求参数
     * @return 行数
     */
    Integer findAllCount(SettlementMonthPageQueryParam param);


    /**
     * 新增
     * @param dto 商户
     * @return 执行结果
     */
    int insert(CcbLifeSettlementMonthDto dto);

    /**
     * 更新
     * @param dto 商户
     * @return 影响行数
     */
    int update(CcbLifeSettlementMonthDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);


}