package cn.com.duiba.quanyi.center.api.enums.ccblife;

import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.Getter;


import java.util.*;

/**
 * @author xjl
 * @date 2023/11/23 18:11
 */
@Getter
@AllArgsConstructor
public enum CostSourceTypeEnum {

    /**
     *
     */
    STORE("1", "商户"),
    ORGAN("2","机构"),
    GOV("3", "政府"),

    ;
    /**
     * 类型
     */
    private final String key;

    /**
     * 来源
     */
    private final String sourceType;

    private static final Map<String, CostSourceTypeEnum> map = new HashMap<>();

    public static Map<String, CostSourceTypeEnum> enumMapWithKey() {
        CostSourceTypeEnum[] values = CostSourceTypeEnum.values();
        for (CostSourceTypeEnum value : values) {
            map.put(value.getKey(), value);
        }
        return map;
    }

    public static Map<String, CostSourceTypeEnum> enumMapWithValue() {
        CostSourceTypeEnum[] values = CostSourceTypeEnum.values();
        for (CostSourceTypeEnum value : values) {
            map.put(value.getSourceType(), value);
        }
        return map;
    }

    public static List<String> getEnumValueByKeys(String[] keys) {
        if (Objects.isNull(keys)) {
            return Collections.emptyList();
        }
        ArrayList<String> list = Lists.newArrayList();
        Map<String, CostSourceTypeEnum> map = enumMapWithKey();
        for (String key : keys) {
            CostSourceTypeEnum typeEnum = map.get(key);
            if (Objects.nonNull(typeEnum)) {
                list.add(typeEnum.getSourceType());
            }
        }
        return list;
    }

    public static List<String> getEnumKeyByValues(String[] values) {
        if (Objects.isNull(values)) {
            return Collections.emptyList();
        }
        ArrayList<String> list = Lists.newArrayList();
        Map<String, CostSourceTypeEnum> map = enumMapWithValue();
        for (String value : values) {
            CostSourceTypeEnum typeEnum = map.get(value);
            if (Objects.nonNull(typeEnum)) {
                list.add(typeEnum.getKey());
            }
        }
        return list;
    }
}
