package cn.com.duiba.quanyi.center.api.param.ccbLife;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Set;

/**
 * @author xjl
 * @date 2023/11/25 21:59
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class SettlementMonthSearchParam extends PageQuery {


    private static final long serialVersionUID = -1789632068405085318L;

    /**
     * 商户号
     */
    private String businessNum;

    /**
     * 门店号
     */
    private String shopNum;

    /**
     * 商户名
     */
    private String businessName;

    /**
     * 门店名
     */
    private String shopName;

    /**
     * 结算月份:开始
     */
    private long monthBegin;

    /**
     * 结算月份：结束
     */
    private long monthOver;

    /**
     * 确认状态 ：待确认：0（默认）；已确认：1
     */
    private Integer status;

    /**
     *门店号集合
     */
    private Set<Long> shopNums;

    /**
     * 主键id字段
     */
    private Long id;


}
