package cn.com.duiba.quanyi.center.api.param.pkg;

import cn.com.duiba.quanyi.center.api.enums.pkg.GoodsPkgBizTypeEnum;
import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;

/**
 * 商品包表
 *
 * @author kjj mybatis generator
 * @date 2023-09-14
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class GoodsPkgSearchParam extends PageQuery {

    private static final long serialVersionUID = 169465853861159L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 业务类型：1=权益卡券包、2=兑吧卡密包
     *
     * @see GoodsPkgBizTypeEnum
     */
    private Integer bizType = GoodsPkgBizTypeEnum.QUANYI_KAQUAN_PKG.getType();

    /**
     * 创建人sso id
     */
    private Long createOperatorId;

    /**
     * 商品包名称
     */
    private String goodsPkgName;

    /**
     * 合同主键ID集合, tb_contract.id
     */
    private List<Long> contractIdList;
}