package cn.com.duiba.quanyi.center.api.dto.goods;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 商品库下单结果
 * @author lizhi
 * @date 2023/8/18 16:16
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
public class GoodsOrderResultDto implements Serializable {
    
    private static final long serialVersionUID = 2440785135308791075L;

    /**
     * 订单状态, 1-处理中，2-成功，3-失败, 4-异常
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderStatusEnum#getStatus()
     */
    private Integer orderStatus;

    /**
     * 错误码
     */
    private String failCode;
}
