package cn.com.duiba.quanyi.center.api.param.coupon;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;

/**
 * @author lizhi
 * @date 2023/8/21 14:24
 */
@ToString
@EqualsAndHashCode(callSuper = true)
@Data
public class WxCouponPageParam extends PageQuery {
    
    private static final long serialVersionUID = -5461048170996409136L;

    /**
     * 微信批次号
     */
    private String stockId;

    /**
     * 创建人
     */
    private String createOperatorName;

    /**
     * 需求商品主键, tb_demand_goods.id
     */
    private List<Long> demandGoodsIds;

    /**
     * 面额，单位分
     */
    private Long couponAmount;

    /**
     * 批次类型
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.WxStockTypeEnum
     */
    private List<Integer> stockTypes;
}
