package cn.com.duiba.quanyi.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.common.UploadTaskDto;
import cn.com.duiba.quanyi.center.api.param.UploadTaskSaveParam;
import cn.com.duiba.quanyi.center.api.param.UploadTaskUpdateResultParam;

/**
 * 上传任务表 服务类
 * @author lizhi
 * @date 2023/8/4 17:29
 */
@AdvancedFeignClient
public interface RemoteUploadTaskService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 上传任务
     */
    UploadTaskDto selectById(Long id);


    /**
     * 保存上传任务
     * @param param 保存参数
     * @return 任务ID
     */
    Long saveTask(UploadTaskSaveParam param);

    /**
     * 更改任务状态
     * @param id 主键
     * @param status 要更改为的状态
     *               {@link cn.com.duiba.quanyi.center.api.enums.UploadTaskStatusEnum}
     * @return 执行结果
     */
    int updateTaskStatus(Long id, Integer status);

    /**
     * 更新上传结果
     * @param param 上传结果
     * @return 执行结果
     */
    int updateResult(UploadTaskUpdateResultParam param);
}
