package cn.com.duiba.quanyi.center.api.remoteservice.activity;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityOrderDto;

import java.util.List;

/**
 * 活动支付订单
 * @author kjj mybatis generator 
 * @date 2023-08-07
 */
@AdvancedFeignClient
public interface RemoteActivityOrderService {

    /**
     * 根据订单号查询
     * @param bizOrderNo 订单号
     * @return 活动支付订单
     */
    ActivityOrderDto selectByBizOrderNo(String bizOrderNo);

    /**
     * C端-用户支付记录分页查询
     * @param userId 用户ID
     * @param lastId 上次最后一个ID，第一页为null
     * @param pageSize 需要拉去的条数
     * @return 支付记录
     */
    List<ActivityOrderDto> selectUserList(Long userId, Long lastId, Integer pageSize);
}