package cn.com.duiba.quanyi.center.api.remoteservice.pkg;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.pkg.GoodsPkgDto;
import cn.com.duiba.quanyi.center.api.param.pkg.GoodsPkgSearchParam;

import java.util.List;

/**
 * 商品包远程服务
 */
@AdvancedFeignClient
public interface RemoteGoodsPkgService {
    /**
     * 分页查询
     *
     * @return 商品包
     */
    List<GoodsPkgDto> selectPage(GoodsPkgSearchParam params);

    /**
     * 根据条件,查询记录的总记录数
     *
     * @param id 商品包Id
     * @return 符合条件的记录数
     */
    Long selectCount(Long id);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 活动
     */
    GoodsPkgDto selectById(Long id);

    /**
     * 创建商品包
     *
     * @param goodsPkgDto 新增的商品包实体
     * @return id
     */
    Long insert(GoodsPkgDto goodsPkgDto);

    /**
     * 更新商品包
     *
     * @param goodsPkgDto 更新的商品包实体
     * @return id
     */
    int update(GoodsPkgDto goodsPkgDto);
}
