package cn.com.duiba.quanyi.center.api.param.api;

import lombok.Data;

import java.io.Serializable;

/**
 * API供给标准下单参数
 * @author lizhi
 * @date 2023/12/4 20:29
 */
@Data
public class ApiCreateOrderParam implements Serializable {
    
    private static final long serialVersionUID = -4402952009826854906L;

    /**
     * API对接ID
     */
    private Long apiJointId;

    /**
     * 商品ID
     */
    private Long specId;

    /**
     * 商品类型
     * 
     * @see cn.com.duiba.quanyi.center.api.enums.api.ApiSpecTypeEnum
     */
    private Integer specType;

    /**
     * 客户单号
     */
    private String thirdOrderId;

    /**
     * 下单结果、状态变更通知url
     */
    private String notifyUrl;

    /**
     * 开发者自有参数，兑吧透传
     */
    private String remark;

    /**
     * 指定面额发券，面额
     * 说明：定面额发券场景，券面额，其他场景不需要填，单位：分。 
     * 校验规则：仅在发券时指定面额及门槛的场景才生效，常规发券场景请勿传入该信息。
     * 选填
     */
    private Integer couponValue;

    /**
     * 指定面额发券，券门槛
     * 说明：指定面额发券批次门槛，其他场景不需要，单位：分。 
     * 校验规则：仅在发券时指定面额及门槛的场景才生效，常规发券场景请勿传入该信息。
     * 选填
     */
    private Integer couponMinimum;

    /**
     * 微信用户openId
     */
    private String wxOpenId;

    /**
     * 微信公众号、小程序AppID
     */
    private String wxAppId;

    /**
     * 支付宝用户id，可通过支付宝授权方式获取
     */
    private String alipayUserId;

    /**
     * 支付宝登录账号，邮箱格式
     */
    private String alipayLoginId;

    /**
     * 支付宝登录账号，手机号格式
     */
    private String alipayPhoneId;

    /**
     * 充值手机号
     */
    private String phone;

    /**
     * 是否在订单状态完结后推送
     * @see
     */
    private Integer pkgPushType;
}
