package cn.com.duiba.quanyi.center.api.remoteservice.goods.ext;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.goods.ext.AlipayTakePrizeParamDto;
import cn.com.duiba.quanyi.center.api.dto.goods.ext.GoodsOrderAlipayCountCoinsDto;

/**
 * 商品库订单服务-支付宝数币红包扩展信息
 *
 * @author lizhi
 * @date 2023/9/25 09:40
 */
@AdvancedFeignClient
public interface RemoteGoodsOrderAlipayCountCoinsService {

    /**
     * 根据订单号查询
     *
     * @param goodsOrderNo 订单号
     * @return 对应的优惠券扩展信息
     */
    GoodsOrderAlipayCountCoinsDto selectByGoodsOrderNo(String goodsOrderNo);

    /**
     * 异步领取
     *
     * @param goodsOrderNo 订单号
     * @param userId       支付宝用户ID
     */
    void asyncReceive(String goodsOrderNo, String userId);


    /**
     * 异步领取
     *
     * @param dto 参数
     */
    void asyncTake(AlipayTakePrizeParamDto dto);

    /**
     * 异步领取-重试
     *
     * @param dto 参数
     */
    void asyncTakeRetry(AlipayTakePrizeParamDto dto);
}
