package cn.com.duiba.quanyi.center.api.remoteservice.pkg;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.pkg.GoodsPkgDto;
import cn.com.duiba.quanyi.center.api.param.pkg.GoodsPkgParam;
import cn.com.duiba.quanyi.center.api.param.pkg.GoodsOrderPkgBatchUpdateCreatorParam;
import cn.com.duiba.quanyi.center.api.param.pkg.GoodsPkgSearchParam;

import java.util.List;
import java.util.Set;

/**
 * 商品包远程服务
 */
@AdvancedFeignClient
public interface RemoteGoodsPkgService {
    /**
     * 分页查询
     *
     * @return 商品包
     */
    List<GoodsPkgDto> selectPage(GoodsPkgSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     *
     * @param param 参数
     * @return 符合条件的记录数
     */
    Long selectCount(GoodsPkgSearchParam param);

    /**
     * 根据条件获取总记录数
     * @param goodsPkgParam 封装的条件
     * @return 返回符合条件的记录数
     */
    Long countByParam(GoodsPkgParam goodsPkgParam);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 活动
     */
    GoodsPkgDto selectById(Long id);

    /**
     * 根据主键批量查询
     *
     * @param ids 主键
     * @return 商品包
     */
    List<GoodsPkgDto> selectByIds(Set<Long> ids);

    /**
     * 创建商品包
     *
     * @param goodsPkgDto 新增的商品包实体
     * @return id
     */
    Long insert(GoodsPkgDto goodsPkgDto);

    /**
     * 更新商品包
     *
     * @param goodsPkgDto 更新的商品包实体
     * @return id
     */
    int update(GoodsPkgDto goodsPkgDto);

    /**
     * 删除
     *
     * @param id 主键ID
     * @return 影响行数
     */
    int delete(Long id);

    /**
     * 批量替换创建人
     *
     * @param param 参数
     * @return 影响行数
     */
    int batchUpdateCreator(GoodsOrderPkgBatchUpdateCreatorParam param);

    /**
     * 查询创建人数量
     *
     * @param createOperatorId 创建人ID
     * @return 数量
     */
    long selectCreatorCount(Long createOperatorId);

}
