package cn.com.duiba.quanyi.center.api.enums.icbc.jx;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 江西工行-订单推送状态
 * （0-发放中，1-发放失败，2-发放成功，3-已核销，4-已核账单）
 * @author lyj
 */
@Getter
@AllArgsConstructor
public enum OrderPushStatusEnum {
    /**
     * 0-处理中
     */
    PROCESSING(0, "处理中"),
    /**
     * 1-发放成功
     */
    SUCCESS(1, "发放成功"),
    /**
     * 2-发放失败
     */
    FAIL(2, "发放失败"),
    /**
     * 3-已核销
     */
    VERIFIED(3, "已核销"),
    /**
     * 4-已核账单
     */
    VERIFIED_BILL(4, "已核账单"),
    ;



    private final Integer status;

    private final String desc;

}
