package cn.com.duiba.quanyi.center.api.remoteservice.icbc.jx;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.icbc.jx.IcbcJxUserExtDto;
import cn.com.duiba.quanyi.center.api.param.icbc.jx.IcbcJxUserExtSearchParam;
import java.util.List;

/**
 * 江西工行用户信息表
 * @author kjj mybatis generator 
 * @date 2024-01-10
 */
@AdvancedFeignClient
public interface RemoteIcbcJxUserExtService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 江西工行用户信息集合
     */
    List<IcbcJxUserExtDto> selectPage(IcbcJxUserExtSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(IcbcJxUserExtSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 江西工行用户信息
     */
    IcbcJxUserExtDto selectById(Long id);

    /**
     * 根据主键查询
     * @param mobile 手机号
     * @return 江西工行用户信息
     */
    IcbcJxUserExtDto selectByMobile(Integer mobile);

    /**
     * 新增
     * @param dto 江西工行用户信息
     * @return 执行结果
     */
    int insert(IcbcJxUserExtDto dto);

    /**
     * 更新
     * @param dto 江西工行用户信息
     * @return 影响行数
     */
    int update(IcbcJxUserExtDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}