package cn.com.duiba.quanyi.center.api.remoteservice.ccbLife;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.ccbLife.CcbLifeAccountDto;
import cn.com.duiba.quanyi.center.api.param.ccbLife.CcbLifeAccountSearchParam;
import cn.com.duiba.quanyi.center.api.param.ccbLife.CcbLifeAccountSearchParamPage;

import java.util.List;

/**
 * 用户表
 * @author kjj mybatis generator 
 * @date 2023-11-23
 */
@AdvancedFeignClient
public interface RemoteCcbLifeAccountService {
     
    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return 用户集合
     */
    List<CcbLifeAccountDto> selectList(CcbLifeAccountSearchParam param);


    /**
     * 根据条件查询，分页
     * @param param 查询条件
     * @return 用户集合
     */
    List<CcbLifeAccountDto> selectListNoPage(CcbLifeAccountSearchParamPage param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(CcbLifeAccountSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 用户
     */
    CcbLifeAccountDto selectById(Long id);

    /**
     * 新增
     * @param dto 用户
     * @return 执行结果
     */
    Long insert(CcbLifeAccountDto dto);

    /**
     * 更新
     * @param dto 用户
     * @return 影响行数
     */
    int update(CcbLifeAccountDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}