package cn.com.duiba.quanyi.center.api.remoteservice.pkg;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.pkg.GoodsPkgSkuDto;

import java.util.List;
import java.util.Set;

/**
 * 商品包商品sku远程服务
 */
@AdvancedFeignClient
public interface RemoteGoodsPkgSkuService {
    /**
     * 根据主键查询
     * @param id 主键
     * @return 商品包sku
     */
    GoodsPkgSkuDto selectById(Long id);

    /**
     * 根据主键批量查询
     * @param ids 主键
     * @return 商品包sku
     */
    List<GoodsPkgSkuDto> selectByIds(Set<Long> ids);

    /**
     * 根据商品包ID查询
     * @param goodsPkgId 商品包ID
     * @return 商品包sku列表
     */
    List<GoodsPkgSkuDto> selectByGoodsPkgId(Long goodsPkgId);

    /**
     * 新增
     * @param entity 商品包sku
     * @return 执行结果
     */
    Long insert(GoodsPkgSkuDto entity);

    /**
     * 更新
     * @param entity 商品包sku
     * @return 执行结果
     */
    int update(GoodsPkgSkuDto entity);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int logicDelete(Long id);
}
