package cn.com.duiba.quanyi.center.api.dto.activity;

import cn.com.duiba.quanyi.center.api.enums.activity.BizActTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 活动奖品领取记录
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@Data
public class ActivityPrizeReceiveRecordDto implements Serializable {

    private static final long serialVersionUID = 1983166690426515826L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 员工用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 手机号
     */
    private String userPhone;

    /**
     * 合同主键, tb_contract.id
     */
    private Long contractId;

    /**
     * 需求主键, tb_demand.id
     */
    private Long demandId;

    /**
     * 商品ID
     */
    private Long spuId;

    /**
     * 商品规格ID
     */
    private Long skuId;

    /**
     * 活动类型
     *
     * @see BizActTypeEnum
     */
    private Integer activityType;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 活动奖品id
     */
    private Long activityPrizeId;

    /**
     * 第几次领取
     */
    private Integer takeNum;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}