package cn.com.duiba.quanyi.center.api.remoteservice.qy.icbc;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qy.icbc.IcbcUserDto;
import cn.com.duiba.quanyi.center.api.param.qy.icbc.IcbcUserSearchParam;
import java.util.List;

/**
 * 工行用户信息表
 * @author kjj mybatis generator 
 * @date 2024-02-04
 */
@AdvancedFeignClient
public interface RemoteIcbcUserService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 工行用户信息集合
     */
    List<IcbcUserDto> selectPage(IcbcUserSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(IcbcUserSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 工行用户信息
     */
    IcbcUserDto selectById(Long id);

    /**
     * 新增
     * @param dto 工行用户信息
     * @return 执行结果
     */
    Long insert(IcbcUserDto dto);

    /**
     * 更新
     * @param dto 工行用户信息
     * @return 影响行数
     */
    int update(IcbcUserDto dto);

    /**
     * 根据用户唯一标识查询
     * @param custId
     * @return
     */
    IcbcUserDto selectByCustId(String custId);

    /**
     * 根据用户id查询
     * @param userId
     * @return
     */
    IcbcUserDto selectByUserId(Long userId);
}